

!---------------------------------------------------------------------------
!	HelpRoutines.h, by Emily Short (emshort@mindspring.com) 
!	Version 1.0 
!	8/16/02 
!
!	Being a file of straightforward routines that will make your game print
!	wodges and wodges of text about IF playing. 
!	
!	Some portions based on paraphrase of instructional text by 
!	Stephen Granade.
!---------------------------------------------------------------------------
!
!	RIGHTS:
!	
!	This library file may be treated as public domain.  It may be
!	used in source with or without credit to the original author.  It may be
!	modified at the user's discretion.  It may be freely redistributed.
!	The textual content of the routines may be lifted from their context
!	and reused elsewhere.
!
!
!	INSTALLATION: 
!
!	Include "HelpRoutines" in your gamefile.
!
!
!	CONTENTS:
!
!	-- Three basic formatting routines for doing bold and italic text
!		and for awaiting a keypress.  (The only reason to define these 
!		is to provide z-code/Glulx flexibility.)
!
!	-- LongIntro.  A description of IF, which prints both of
!		-- BasicBrief.  A quick description of IF in the abstract
!		-- BasicIntro.  A somewhat longer description of same, discuss
!
!	-- ExplainPrompt.  What a prompt is.
!	-- StartingInstructions.  Suggests that the player look, examine items,
!			and check his inventory.
!	-- StuckInstructions.  A list of tips for a player in trouble
!
!	-- AllCommunication.  Prints all of the following:
!		-- Communication.  Basic instructions on how to form valid commands.
!		-- OnMovement
!		-- OnObjects 
!		-- OnNPCs, which will also call one of
!			-- AskTellNPC (Define NPC_ASKTELL before including this file)
!			-- MenuNPC (Define NPC_MENU before including this file)
!			-- TalkToNPC (Define NPC_TALKTO before including this file)
!			-- TopicMenuNPC (Define NPC_TOPIC before including this file) 
!		-- MetaCommands.  Introduces SAVE, QUIT, RESTART, RESTORE, UNDO.
!
!	-- StandardVerbs.  A list of standard verbs.  Self-adjusting to reflect
!	    the instructions about NPCS; it will list SCORE only if you have a MAX_SCORE 
!		greater than 0, and the OBJECTS/PLACES commands only if you have not defined
!		NO_PLACES.
!	-- Abbreviations.  A list of abbreviations and their meanings.
!
!	-- OnlineHelp.  How to find online IF manuals.
!	-- MoreGames.  How to find more IF. 
!
!	SEE ALSO: 
!		-- SampleTranscript.h: contains several sample transcripts formatted
!			for inclusion in IF games.
!
!	CAVEAT
!
!	Note that in some cases this material may be incorrect for your game.  
!	You are advised to read the resulting text and determine whether it suits 
!	your ends. 
!
!---------------------------------------------------------------------------


system_file;


!---------------------------------------------------------------------------
! Special effects -- bold-texting and pauses for display purposes
!--------------------------------------------------------------------------- 

#ifdef TARGET_GLULX;
[ ES_Pause i; 
	i = KeyCharPrimitive();  
	if (i=='q') rtrue;
	rfalse; 
];
#ifnot;
[ ES_Pause i;
	@read_char 1 i;
	if (i == 'q') rtrue;
	rfalse; 
];
#endif;

#ifdef TARGET_GLULX;
[ ESB str;	! print something in bold 
	if (str==0) rfalse;
	glk_set_style(style_Input);
	print (string) str; 
	glk_set_style(style_Normal);
	rtrue;
];
#ifnot;
[ ESB str;	! print something in bold 
	if (str==0) rfalse;
	style bold;
	print (string) str; 
	style roman;
	rtrue;
];
#endif;

#ifdef TARGET_GLULX;
[ ESI str;	! print something in italics 
	if (str==0) rfalse;
	glk_set_style(style_Emphasized);
	print (string) str; 
	glk_set_style(style_Normal);
	rtrue;
];
#ifnot;
[ ESI str;	! print something in italics 
	if (str==0) rfalse;
	style underline;
	print (string) str; 
	style roman;
	rtrue;
];
#endif;



!---------------------------------------------------------------------------
! Introductions
!--------------------------------------------------------------------------- 

[ LongIntro;
	BasicBrief();
	new_line;
	BasicIntro();
];

[ BasicBrief;
	print (ESB) "  ^";
	print ",           ().
		        . , 
		 ,      .   -
		 ,          .  
		,              
		     ,    
		  ,     .^";
];

[ BasicIntro;
	print "    :   
		   ,      
		,    -.^^";
	print "          
		    ,    ,    
		. (    , .)
		      ,     ,  
		    .    :
		      ,   ,  
		   .^^";
	print "     @<<@>>,    , 
		  :  ,    ,   ,
		      .^^";
	print (ESB) "  ^^";
	print ":       ,   ,    
		  .    ,      .
		>     .   ,   - ,
		   -    ,     
		  - ,   .^^";
	print ":   ,     ,   .  
		-  -   -?    ,    
		  ,          ,  , 
		   ..^^";
	print " :  ,       . >   
		 >   . >    >   .
		  >        
		  ,     .      
		   ,     .^^";
	print " :  ()      ,   ,  
		      .     
		 , ,   ,      ..,   , 
		     .        ,  
		   , , ,         
		 - .  ,     ,
		   ,  ,    
		-,           ,  
		- ,        ..
		     : > <>  
		<>, > <>  <>, > <> <>, >
		<> <>.^";
	rtrue;
];


!---------------------------------------------------------------------------
! Explain Prompt, Starting Instructions, Stuck Instructions
!--------------------------------------------------------------------------- 


[ ExplainPrompt;
	print (ESB) "^";
	print " ", (ESB) ">", "   ,     .
		  .   ,      .
		, ,   ,  .^";
];

[ StartingInstructions;
	print (ESB) "  ?^";
	print "            .^^";
 	print (ESB) "   . ", "    .^";
 	print (ESB) "     (   ) , ", "   
		. ,   ,     .  -
		   ,  .^";
 	print (ESB) "    , ", " ,    -  
		  .  () ,     .^";
 	print (ESB) "   ,  . ", "      
		   .^";
];

[ StuckInstructions;
	print (ESB) ". ", "       .
		  ,  
		,    .    . ,  
		,  ,  ,   .^^";
	print (ESB) "   . ", "    - ,
		  ,  //    .^^";
	print (ESB) "   . ", "       , 
		 ,     ..     .^^";
	print (ESB) ". ", "  ,   ;      ,
		    .^^";
	if (ES_Pause()) jump end;
	print (ESB) "    . ",
		"   , ,  ,   
		.   .     ,    
		,    .    , 
		   .    .   
		   --     
		 .      ,    .^^";
	print (ESB) ". ",
		"   - ,     ,   
		 .   .    
		 , , ,      .^^";
	if (ES_Pause()) jump end;
	print (ESB) "  . ",
		"   ,   -  .   
		 ,     ,      ,  . 
		        , ,  , 
		 ,    ,   .^^";
	print (ESB) "   . ",
		"    ,     --
		 ,    ,    
		.      , ,   
		     .^^";
	if (ES_Pause()) jump end;
	print (ESB) "  .  ",
		"      ?    ? 
		  --      ,   
		,  ,  ,   , 
		   .    ,  
		 .     ?  
		  ,    ,    .^^";
	print (ESB) "  . ",
		" ,       .  
		  ,      ?    
		 ,    ?^^";
	if (ES_Pause()) jump end;
	print (ESB) "   - . ", "    .^^";
	print (ESB) "    : ", "      
		,    .    ,   ,
		   ifiction    Discord. 
		     ,      ,  
		,   ,     ,      . 
		     .  ,   -, 
		   .^^";
	if (ES_Pause()) jump end;

	print (ESB) " : ",
		"      , ,  . 
		   ,   e-mail ()   ,
		 ,   .^";
	.end;
	"!";
];


!---------------------------------------------------------------------------
! Standard Verbs list
!--------------------------------------------------------------------------- 

[ StandardVerbs flag;
	print "         .
	,         .  
	   :^^";

#ifdef TARGET_GLULX;
	glk_set_style(style_Preformatted);
#ifnot;	
	font off;
#endif;
	print "     ";
	print "       ";
	print "      ";
	print " ";
	print "^";
	print "^";
	
	print "     ";
	print "         ";
	print "     ";
	print "    ";
	print "^";
	
	print "    ";
	print "     ";
	print "^";
	print "^";

	print " []  ";
	print " []     ";
	print " [] ";
	print " []  ";
	print "^";
	 
	print "[]       ";
	print "[]       ";
	print "[]       ";
	print "[]       ";
	print "^"; 
	
	print "      ";
	print "       ";
	print "      ";
	print "      ";
	print "^";
	 
	print "     ";
	print "    ";
	print "      ";
	print "   ";
	print "^";
	print "^";
	
	print "   ";
	print "   ";
	print "    ";
	print "    ";
	print "^";
	
	print "   ";
	print "  ";
	print " ";
	print "  ^";
	print "   ";
	
	print "   ";
	print "   ";
	print "   ";
	print "^";
	print "^";
	
	print "    ";
	print "    ";
	print "   ";
	print "      ";
	print "^";
		
	print "       ";
	print "       ";
	print "     ";
	print "      ";
	print "^";
	
	print "    ";
	print "    ";
	print "  ";
	print "     ";
	print "^";
	
	print "     ";
	print "     ";
	print "     ";
	print "    ";
	print "^";
	
	print "     ";
	print "    ";
	print "  ";
	print "      ";
	print "^";
	print "      ";
	print "       ";
	print "     "; 
	print "^";
	print "^";
	
	print "       ";
	print "   ";
	print " ";
	print " ";
	print "^";
	
	print "    ";
	print "     ";
	
#ifdef NPC_ASKTELL;
	print "   ";
	print "^";
	print "^";
	print "   ";
	print "  ";
#endif;
#ifdef NPC_TOPIC;
	print "    ";
	print "   ";
#endif;
#ifdef NPC_TALKTO;
	print "  ";
#endif;
#ifdef NPC_MENU;
	print "  ";
#endif;
	print "^";
	
#ifdef TARGET_GLULX;
	glk_set_style(style_Normal);
#ifnot;	
	font on;
#endif;

	print "^^,   :^^";
#ifdef TARGET_GLULX;
	glk_set_style(style_Preformatted);
#ifnot;	
	font off;
#endif; 
	print "         ^";
	print "                  ^";
	print "         ^";
#ifndef NO_PLACES;
	print "           ^";
#endif;
#ifdef MAX_SCORE; 
	if (max_score > 0)
	{	print "       ";
		print "   ";
		print "  ";
		flag = 1;
	}
#endif; 
#ifdef TASKS_PROVIDED;
	if (max_score > 0)
	{
		print "";
		flag = 1;
	}
#endif;
	if (flag) print "^"; 
#ifdef TARGET_GLULX;
	glk_set_style(style_Normal);
#ifnot;	
	font on;
#endif;
];

[ Abbreviations; 
	print " :^^";
	print " -- .^";
	print "  -- .^";
	print "  -- . ,     .^";
	print "  -- .  .^";
	print " <> --  .^";
	print "  -- .^";
	print " -- -.^";
	print " -- -.^";
	!print "Q -- QUIT.^";
	print "  -- .^";
	print " -- -.^";
	print " -- -.^";
	print " -- .^";
	print "  -- .^";
	print "  -- .^";
	new_line;
];

!---------------------------------------------------------------------------
! Communication etc.
!--------------------------------------------------------------------------- 

[ AllCommunication;
	Communication();
	OnMovement();
	OnObjects(); 
	OnNPCs();
	MetaCommands();
];

[ Communication; 
	print (ESB) "^";
	print "      ,  
		  . , >   >  .^^";
];
[ OnMovement; 
	print (ESB) "  ^";
	print "        ().     
		,    ,     .   
		   : ,    ,   
		 ( ).     ,   .^^";
	print "      ,   ,
		   .         . 
		  , , , , , , ,
		,   ,   , , , , , , , , , .^^";
	print "        .^^";
];
[ OnObjects;
	print (ESB) "^";
	print "      ,   
		  .    ()  
		(   ).  ( )   ,
		    .^^";	
	print "     ,      ,
		, , , , .^^";
	print "     ,     ,
		      .  ,    
		  ,       .^^";
]; 
[ OnNPCs;
	print (ESB) "^"; 
#ifdef NPC_MENU;
	MenuNPC();
	rtrue;
#endif;
#ifdef NPC_TALKTO;
	TalkToNPC();
	rtrue;
#endif;
#ifdef NPC_TOPIC;
	TopicMenuNPC();
	rtrue;
#endif; 
	AskTellNPC(); 
	rtrue;
];

[ AskTellNPC;
	print "         .    
		    .  ,      .
		    :^^";
	print "   .^";
	print (ESB) ">    ^";
	print (ESB) ">   ^^";
	print "  .^";
	print (ESB) ">  ^";
	print (ESB) ">    ^^";
	print "   .^";
	print (ESB) ">    ^";
	print (ESB) ">    ^^";
	print "  .^";
	print (ESB) ">, ^";
	print (ESB) "> ,    ^";
	print "@<<, @>>, -    ,       ,
		     .^";
];

[ MenuNPC;
	print "         .   
		 >  .     ,    
		      .^^";
	print "     - :^^"; 
	print (ESB) ">  ^";
	print (ESB) ">    ^^";
	print "   .^";
	print (ESB) ">, ^";
	print (ESB) "> ,    ^";
	print "      ,   .^";
];
[ TalkToNPC;
	print "         .    
		    .  ,    > 
		,   ,    .^"; 
];

[ TopicMenuNPC;
	print "         .    
		    .  ,      .
		    :^^";
	print "   .^";
	print (ESB) ">   ^";
	print (ESB) ">    ^^";
	print " .^";
	print (ESB) ">  ^";
	print (ESB) ">    ^^";
	print ".^";
	print (ESB) ">, ^";
	print (ESB) "> ,    ^";
	print "       .^^";
];

[ MetaCommands;
	print (ESB) "^";
	print "      :^^";
	print (ESB) "", " --    .^";
	print (ESB) "", " --     .  (    ,
		 .)^";
	print (ESB) "", " --   .^";
	print (ESB) "", " --          .^";
	print (ESB) "", " --  .^";
];


!---------------------------------------------------------------------------
! About the IF community online
!--------------------------------------------------------------------------- 

[ OnlineHelp;
	print (ESB) "  ^^";
		print "       :^^";
		print "     (Frederik Ramsberg), www.octagate.com/Fredrik/IFGuide/^";
		print "  -- , adamcadre.ac/content/if.txt^";
		print "   , www.tads.org/if.htm^^";
		print "     ,   -    ,
			  :^^";
		print " , www.brasslantern.org^";
		print "Baf's      (Baf), www.wurb.com/if/index^^";
		print "             google:
			rec.games.int-fiction.^^";
		print "      ,         ,
			   ,   groups.google.com,   @<<rec@>>,  @<<rec.games@>>,
			 @<<rec.games.int-fiction@>>.     ,   .
			       ,  ,  ,  
			@<<FAQ@>>,   .      ,    ,
			  .^^";
];

[ MoreGames;
	print (ESB) " -^^";
	print " Discord-: https://discord.gg/X86kkzM^^";
	print " ,   ,    : http://ifiction.ru/^^";
	print ",     Inform (    ), http://rinform.stormway.ru/^^";
	print "IRC-,       : #ifrus   irc.forestnet.org^";
];
