

!---------------------------------------------------------------------------
!	HelpRoutines.h, by Emily Short (emshort@mindspring.com) 
!	Version 1.0 
!	8/16/02 
!
!	Being a file of straightforward routines that will make your game print
!	wodges and wodges of text about IF playing. 
!	
!	Some portions based on paraphrase of instructional text by 
!	Stephen Granade.
!---------------------------------------------------------------------------
!
!	RIGHTS:
!	
!	This library file may be treated as public domain.  It may be
!	used in source with or without credit to the original author.  It may be
!	modified at the user's discretion.  It may be freely redistributed.
!	The textual content of the routines may be lifted from their context
!	and reused elsewhere.
!
!
!	INSTALLATION: 
!
!	Include "HelpRoutines" in your gamefile.
!
!
!	CONTENTS:
!
!	-- Three basic formatting routines for doing bold and italic text
!		and for awaiting a keypress.  (The only reason to define these 
!		is to provide z-code/Glulx flexibility.)
!
!	-- LongIntro.  A description of IF, which prints both of
!		-- BasicBrief.  A quick description of IF in the abstract
!		-- BasicIntro.  A somewhat longer description of same, discuss
!
!	-- ExplainPrompt.  What a prompt is.
!	-- StartingInstructions.  Suggests that the player look, examine items,
!			and check his inventory.
!	-- StuckInstructions.  A list of tips for a player in trouble
!
!	-- AllCommunication.  Prints all of the following:
!		-- Communication.  Basic instructions on how to form valid commands.
!		-- OnMovement
!		-- OnObjects 
!		-- OnNPCs, which will also call one of
!			-- AskTellNPC (Define NPC_ASKTELL before including this file)
!			-- MenuNPC (Define NPC_MENU before including this file)
!			-- TalkToNPC (Define NPC_TALKTO before including this file)
!			-- TopicMenuNPC (Define NPC_TOPIC before including this file) 
!		-- MetaCommands.  Introduces SAVE, QUIT, RESTART, RESTORE, UNDO.
!
!	-- StandardVerbs.  A list of standard verbs.  Self-adjusting to reflect
!	    the instructions about NPCS; it will list SCORE only if you have a MAX_SCORE 
!		greater than 0, and the OBJECTS/PLACES commands only if you have not defined
!		NO_PLACES.
!	-- Abbreviations.  A list of abbreviations and their meanings.
!
!	-- OnlineHelp.  How to find online IF manuals.
!	-- MoreGames.  How to find more IF. 
!
!	SEE ALSO: 
!		-- SampleTranscript.h: contains several sample transcripts formatted
!			for inclusion in IF games.
!
!	CAVEAT
!
!	Note that in some cases this material may be incorrect for your game.  
!	You are advised to read the resulting text and determine whether it suits 
!	your ends. 
!
!---------------------------------------------------------------------------


system_file;


!---------------------------------------------------------------------------
! Special effects -- bold-texting and pauses for display purposes
!--------------------------------------------------------------------------- 

#ifdef TARGET_GLULX;
[ ES_Pause i; 
	i = KeyCharPrimitive();  
	if (i=='q') rtrue;
	rfalse; 
];
#ifnot;
[ ES_Pause i;
	@read_char 1 i;
	if (i == 'q') rtrue;
	rfalse; 
];
#endif;

#ifdef TARGET_GLULX;
[ ESB str;	! print something in bold 
	if (str==0) rfalse;
	glk_set_style(style_Input);
	print (string) str; 
	glk_set_style(style_Normal);
	rtrue;
];
#ifnot;
[ ESB str;	! print something in bold 
	if (str==0) rfalse;
	style bold;
	print (string) str; 
	style roman;
	rtrue;
];
#endif;

#ifdef TARGET_GLULX;
[ ESI str;	! print something in italics 
	if (str==0) rfalse;
	glk_set_style(style_Emphasized);
	print (string) str; 
	glk_set_style(style_Normal);
	rtrue;
];
#ifnot;
[ ESI str;	! print something in italics 
	if (str==0) rfalse;
	style underline;
	print (string) str; 
	style roman;
	rtrue;
];
#endif;



!---------------------------------------------------------------------------
! Introductions
!--------------------------------------------------------------------------- 

[ LongIntro;
	BasicBrief();
	new_line;
	BasicIntro();
];

[ BasicBrief;
	print (ESB) "Об Интерактивной Литературе^";
	print "Игра, которую вы скачали — это произведение в жанре Интерактивной Литературы (ИЛ).
		В интерактивной литературе вы играете за главного героя истории. Команды, которые
		вы вводите, определяют действия персонажа и течение сюжета. В некоторых ИЛ-играх
		есть графика, но в большинстве её нет — образы создаёт ваше воображение. С другой
		стороны,  вам доступен обширный выбор действий — в то время как в других играх
		ваши действия могут быть ограничены стрельбой, передвижением или исследованием вещей
		с помощью мыши, ИЛ позволяет использовать множество глаголов.^";
];

[ BasicIntro;
	print "Существуют различные виды интерактивной литературы: в некоторых акцент
		поставлен на разгадывании загадок, некоторые хотят провести вас по череде
		событий, некоторые предлагают исследовать что-либо.^^";
	print "В играх со множеством загадок вы будете проводить большее количество времени
		слоняясь повсюду и пытаясь понять, что же делать дальше, в этом заключается основное
		развлечение. (Если вам нравится подобное времяпрепровождение, конечно.)
		В начале игры вы обычно можете понять, игра какого рода перед вами, и каких
		действий автор от вас ожидает. Внимательно прочитайте вступительный текст:
		в нём может содержаться информация о персонаже, которым вы играете, об игровых
		задачах и тому подобное.^^";
	print "Если игра предлагает ввести слово @<<инфо@>>, перед тем как начать, вам
		лучше это сделать: скорее всего, вы узнаете особые команды, или другие данные,
		без которых не сможете дойти до конца.^^";
	print (ESB) "КАК УСТРОЕН МИР^^";
	print "Пространство: Действие большинства игр ИЛ происходит в мире, сделанном из комнат, которые сами по 
		себе не разделены. Можно переходить между комнатами, но по самой комнате ходить нельзя.
		>ПОДОЙТИ К СТОЛУ вряд ли сработает. С другой стороны, если про что-то написано,
		что оно находится где-то высоко или вне досягаемости, то иногда имеет смысл 
		встать на какой-нибудь объект, чтобы стать выше.^^";
	print "Расположение: Одна из вещей, которая тщательно выполнена в ИЛ, это расположение предметов. Лежит ли
		что-то внутри чего-то или на чём-то? Игра следит за этим, и множество головоломок 
		зависят от того, где находятся предметы — у игрока или на полу комнаты, на столе, 
		в коробке и т.д.^^";
	print "Типы действий: Большинство действий, осуществимых в мире ИЛ краткие и точные. >ИДТИ НА ЗАПАД 
		или >ОТКРЫТЬ ДВЕРЬ наверняка сработают. >ПОЕХАТЬ В ПУТЕШЕСТВИЕ или >СДЕЛАТЬ СТОЛ наверняка нет.
		Действия наподобие >ПОЙТИ К ОТЕЛЮ зависят от игры — в 
		некоторых это сработает, но в большинстве — нет. Чаще всего сложные действия нужно 
		разбивать на отдельные команды, чтобы игра смогла их понять.^^";
	print "Прочие персонажи: Прочие (неигровые) персонажи в ИЛ часто весьма ограничены, хотя существуют игры, в 
		которых общение с персонажами играет важнейшую роль. Если персонаж отвечает на 
		многие вопросы, помнит, что ему говорили, двигается сам по себе и т.д., то скорее всего, 
		он может быть важен в игре. Если же у него стандартные ответы и непохоже, что автор
		много в него вложил, то, наверное, он добавлен как массовка или чтобы помочь при 
		выполнении какой-то головоломки. В играх, сильно ориентированных на разгадки головоломок,
		персонажей часто приходится подкупать, угрожать им, или заставить сделать 
		что-то, что сам игрок сделать не может — выдать информацию или предмет, достать 
		куда-нибудь высоко, позволить игроку пройти в недоступную локацию и т.д.
		Стандартные команды для общения с персонажами: >СПРОСИТЬ <персонажа> ПРО 
		<тему>, >РАССКАЗАТЬ <персонажу> ПРО <тему>, >ДАТЬ <предмет> <персонажу>, >ПОКАЗАТЬ
		<предмет> <персонажу>.^";
	rtrue;
];


!---------------------------------------------------------------------------
! Explain Prompt, Starting Instructions, Stuck Instructions
!--------------------------------------------------------------------------- 


[ ExplainPrompt;
	print (ESB) "ПОДСКАЗКА^";
	print "Знаком ", (ESB) ">", " игра спрашивает вас, что вы хотите сейчас сделать.
		Отвечать следует командой. Обычно это глагол, за которым идут предлоги и объекты.
		Например, ПОСМОТРЕТЬ, ПОСМОТРЕТЬ НА РЫБУ, ВЗЯТЬ РЫБУ.^";
];

[ StartingInstructions;
	print (ESB) "С ЧЕГО НАЧАТЬ?^";
	print "Первым делом при запуске игры следует ознакомиться с окружением и понять цель игры.^^";
 	print (ESB) "Внимательно прочтите вступительный текст. ", "Иногда в нём содержатся подсказки.^";
 	print (ESB) "Также вам будет нужно ОСМОТРЕТЬ (ОСМ или просто О) комнату, ", "в которой вы 
		находитесь. Узнайте, где находятся выходы, и какие объекты здесь описаны. Если какие-то
		из них кажутся интересными, ОСМОТРИТЕ их.^";
 	print (ESB) "Вам также следует ОСМОТРЕТЬ СЕБЯ, ", "чтобы узнать, оставил ли автор какие-то сведения 
		о вашем персонаже. ИНВЕНТАРЬ (ИНВ) покажет, что вы несёте с собой.^";
 	print (ESB) "Как только вы сориентируетесь, начинайте изучение. ", "Двигайтесь от комнаты к комнате и 
		осматривайте каждую доступную локацию.^";
];

[ StuckInstructions;
	print (ESB) "Изучайте. ", "Осматривайте все объекты вокруг и в вашем инвентаре.
		Открывайте все двери, которые 
		находите, и заходите в них. Смотрите внутрь закрытых контейнеров. Убедитесь, что сделали
		всё, что можно, с тем, что находится вокруг.^^";
	print (ESB) "Используйте все пять чувств. ", "Если в игре упоминается какая-то поверхность,
		запах или звук, попробуйте прикоснуться/понюхать/послушать или попробовать на вкус.^^";
	print (ESB) "Будьте внимательны и скрупулёзны. ", "Если вы всё ещё не понимаете что делать, попробуйте
		открывать окна, заглядывать под кровати и т.п. Иногда объекты очень хорошо спрятаны.^^";
	print (ESB) "Перечитывайте. ", "Возвращайтесь к вещам, которые уже видели; порой это может натолкнуть на идею,
		которая вас раньше не посещала.^^";
	if (ES_Pause()) jump end;
	print (ESB) "Ищите подсказки в тексте игры. ",
		"Объекты с обширным описанием, возможно, более важны, чем описанные одной
		строкой. Поэкспериментируйте с ними. Если в описании машины указано, что она состоит из
		деталей, попробуйти взаимодействовать с ними. Обращайте внимание на то, какие
		глаголы использует сама игра. Попробуйти употребить их сами. В играх часто
		встречаются специальные глаголы — названия магических заклинаний или другие
		особые слова. Никогда не повредит попробовать сделать то, на что намекает игра.^^";
	print (ESB) "Перефразируйте. ",
		"Если вы задумали что-то сделать, но игра вас не понимает, попробуйте сказать это
		другими словами. Зачастую синонимы подходят. Обычно разработчик пытается предусмотреть
		все синонимы, но, возможно, ваши не пришли ему в голову.^^";
	if (ES_Pause()) jump end;
	print (ESB) "Пробуйте разные варианты. ",
		"Иногда действие не срабатывает, но даёт какой-то неожиданный результат. Чаще всего 
		это означает, что вы на правильном пути, даже если не до конца понятно, что делать. 
		Если нажатие на красную кнопку вызывает скрежет за стеной, то, быть может, нажатие
		сначала синей, а потом красной кнопки, откроет скрытую дверь.^^";
	print (ESB) "Постарайтесь понять логику игры. ",
		"Иногда игровая система использует понятия, не встречающиеся в повседневности --
		к примеру, различная магия или технологии, не существующие в современном
		мире. Если в игре использована подобная система, подумайте, как её использование
		может помочь вам решить поставленные задачи.^^";
	if (ES_Pause()) jump end;
	print (ESB) "Исследуйте весь экран.  ",
		"Кроме главного окна есть ли ещё дополнительные? Что в них происходит? Проверьте
		строку состояния — в ней может содержаться название локации, в которой вы
		находитесь, количество очков, время суток, состояние здоровья персонажа, и
		многая другая ценная информация. Если её содержимое изменилось, это тоже
		заслуживает внимания. Когда и почему произошло изменение? Если изменилось
		значение здоровья персонажа, вы можете быть уверены, что это важная информация.^^";
	print (ESB) "Учитывайте жанр игры. ",
		"В детективах, романах и триллерах разные действия и мотивации. Что 
		пытаетесь сделать вы, и что бы сделал типичный персонаж? Каково разумное поведение 
		для детектива, героини романа или шпиона?^^";
	if (ES_Pause()) jump end;
	print (ESB) "Играйте вместе с кем-нибудь ещё. ", "Две головы обычно лучше одной.^^";
	print (ESB) "Попробуйте ввести ИНФО или СПРАВКА: ", "часто среди информации об игре можно найти
		подсказки, как пройти сложные места. Если это не сработает, напишите письмо автору,
		спросите на форумах ifiction или в чатах Discord. Желательно
		указать название игры в теме сообщения, и оставить пустое место в начале, чтобы тот
		эпизод, который вы описываете, не бросался в глаза тем, кто ещё не дошёл до него. Затем
		опишите проблему как можно более ясно. Скорее всего, вскоре найдтся кто-нибудь, кто
		поможет разгадать эту загадку.^^";
	if (ES_Pause()) jump end;

	print (ESB) "Напишите автору: ",
		"Если вы застряли в совсем неожиданном месте, возможно, это баг. Если
		вы уверены в этом, напишите автору e-mail (корректно) с описанием проблемы,
		и спросите, как её избежать.^";
	.end;
	"Удачи!";
];


!---------------------------------------------------------------------------
! Standard Verbs list
!--------------------------------------------------------------------------- 

[ StandardVerbs flag;
	print "Здесь вы найдёте список стандартных команд для игр вроде этой.
	Учтите, что в этой игре могут встречаться и другие глаголы. Этот список
	пригодится вам для начала:^^";

#ifdef TARGET_GLULX;
	glk_set_style(style_Preformatted);
#ifnot;	
	font off;
#endif;
	print "ОСМОТРЕТЬ     ";
	print "ИЗУЧИТЬ       ";
	print "ОБЫСКАТЬ      ";
	print "ПОСМОТРЕТЬ ПОД";
	print "^";
	print "^";
	
	print "ИНВЕНТАРЬ     ";
	print "ВЗЯТЬ         ";
	print "ВЫБРОСИТЬ     ";
	print "ОПОРОЖНИТЬ    ";
	print "^";
	
	print "ПОЛОЖИТЬ НА   ";
	print "ПОЛОЖИТЬ В    ";
	print "^";
	print "^";

	print "СЕВЕР [С]  ";
	print "ЮГ [Ю]     ";
	print "ВОСТОК [В] ";
	print "ЗАПАД [З]  ";
	print "^";
	 
	print "[СВ]       ";
	print "[СЗ]       ";
	print "[ЮВ]       ";
	print "[ЮЗ]       ";
	print "^"; 
	
	print "ВВЕРХ      ";
	print "ВНИЗ       ";
	print "ВОЙТИ      ";
	print "ВЫЙТИ      ";
	print "^";
	 
	print "СЛЕЗТЬ     ";
	print "ЗАЛЕЗТЬ    ";
	print "ПЛЫТЬ      ";
	print "ПРЫГНУТЬ   ";
	print "^";
	print "^";
	
	print "ЗАПЕРЕТЬ   ";
	print "ОТПЕРЕТЬ   ";
	print "ОТКРЫТЬ    ";
	print "ЗАКРЫТЬ    ";
	print "^";
	
	print "ВКЛЮЧИТЬ   ";
	print "ВЫКЛЮЧИТЬ  ";
	print "УСТАНОВИТЬ ";
	print "ПОВЕРНУТЬ  ^";
	print "ОБЫСКАТЬ   ";
	
	print "ПОТЯНУТЬ   ";
	print "ТОЛКНУТЬ   ";
	print "БРОСИТЬ В  ";
	print "^";
	print "^";
	
	print "КАЧНУТЬ    ";
	print "МАХНУТЬ    ";
	print "ПОТЕРЕТЬ   ";
	print "СЖАТЬ      ";
	print "^";
		
	print "ЕСТЬ       ";
	print "ПИТЬ       ";
	print "НАДЕТЬ     ";
	print "СНЯТЬ      ";
	print "^";
	
	print "СЛУШАТЬ    ";
	print "ЛИЗНУТЬ    ";
	print "КОСНУТЬСЯ  ";
	print "НЮХАТЬ     ";
	print "^";
	
	print "ЗАЖЕЧЬ     ";
	print "КОПАТЬ     ";
	print "РЕЗАТЬ     ";
	print "СВЯЗАТЬ    ";
	print "^";
	
	print "ЗАДУТЬ     ";
	print "СЛОМАТЬ    ";
	print "НАПОЛНИТЬ  ";
	print "ЖДАТЬ      ";
	print "^";
	print "СПАТЬ      ";
	print "ПЕТЬ       ";
	print "ДУМАТЬ     "; 
	print "^";
	print "^";
	
	print "ДАТЬ       ";
	print "ПОКАЗАТЬ   ";
	print "ПРОСНУТЬСЯ ";
	print "ПОЦЕЛОВАТЬ ";
	print "^";
	
	print "УДАРИТЬ    ";
	print "КУПИТЬ     ";
	
#ifdef NPC_ASKTELL;
	print "ГОВОРИТЬ   ";
	print "^";
	print "^";
	print "СКАЗАТЬ О  ";
	print "СПРОСИТЬ О ";
#endif;
#ifdef NPC_TOPIC;
	print "СКАЗАТЬ    ";
	print "СПРОСИТЬ   ";
#endif;
#ifdef NPC_TALKTO;
	print "ГОВОРИТЬ С ";
#endif;
#ifdef NPC_MENU;
	print "ГОВОРИТЬ С ";
#endif;
	print "^";
	
#ifdef TARGET_GLULX;
	glk_set_style(style_Normal);
#ifnot;	
	font on;
#endif;

	print "^^Команды, управляющие самой игрой:^^";
#ifdef TARGET_GLULX;
	glk_set_style(style_Preformatted);
#ifnot;	
	font off;
#endif; 
	print "ПЕРЕЗАПУСК    ЗАГРУЗИТЬ     СОХРАНИТЬ^";
	print "КОНЕЦ         ОТКАТ         МЕСТОИМЕНИЯ^";
	print "СКРИПТ ВКЛ    СКРИПТ ВЫКЛ   ПРОВЕРИТЬ^";
#ifndef NO_PLACES;
	print "ПРЕДМЕТЫ      МЕСТА     ^";
#endif;
#ifdef MAX_SCORE; 
	if (max_score > 0)
	{	print "СЧЕТ       ";
		print "ИЗВЕЩ ВКЛ  ";
		print "ИЗВЕЩ ВЫКЛ ";
		flag = 1;
	}
#endif; 
#ifdef TASKS_PROVIDED;
	if (max_score > 0)
	{
		print "СЧЕТ";
		flag = 1;
	}
#endif;
	if (flag) print "^"; 
#ifdef TARGET_GLULX;
	glk_set_style(style_Normal);
#ifnot;	
	font on;
#endif;
];

[ Abbreviations; 
	print "Стандартные сокращения:^^";
	print "ВН — ВНИЗ.^";
	print "В  — ВОСТОК.^";
	print "И  — ИНВЕНТАРЬ. Посмотреть, что у вас с собой.^";
	print "О  — ОСМОТРЕТЬСЯ. Посмотреть вокруг.^";
	print "О <предмет> — Изучить предмет.^";
	print "С  — СЕВЕР.^";
	print "СВ — СЕВЕРО-ВОСТОК.^";
	print "СЗ — СЕВЕРО-ЗАПАД.^";
	!print "Q — QUIT.^";
	print "Ю  — ЮГ.^";
	print "ЮВ — ЮГО-ВОСТОК.^";
	print "ЮЗ — ЮГО-ЗАПАД.^";
	print "ВВ — ВВЕРХ.^";
	print "З  — ЗАПАД.^";
	print "Ж  — ЖДАТЬ.^";
	new_line;
];

!---------------------------------------------------------------------------
! Communication etc.
!--------------------------------------------------------------------------- 

[ AllCommunication;
	Communication();
	OnMovement();
	OnObjects(); 
	OnNPCs();
	MetaCommands();
];

[ Communication; 
	print (ESB) "ВЗАИМОДЕЙСТВИЕ^";
	print "Для управления игрой вам требуется вводить команды, начинающиеся с
		глагола в инфинитиве. Например, >ЗАКРЫТЬ ДВЕРЬ или >ПОСМОТРЕТЬ ПОД КРОВАТЬЮ.^^";
];
[ OnMovement; 
	print (ESB) "КОМНАТЫ И ПЕРЕМЕЩЕНИЕ^";
	print "В каждый момент вы находитесь в определённой локации (комнате). Когда вы заходите в 
		комнату, игра выведет описание того, что вы видите этой комнате. В этом описании
		содержатся два важных момента: предметы, с которыми можно взаимодействовать, и список 
		выходов (путей наружу). Чтобы снова увидеть описание комнаты, просто введите ОСМ.^^";
	print "Чтобы покинуть комнату и перейти в другую, используйте стороны света,
		например ИДТИ НА СЕВЕР. Для простоты можно опускать слово ИДТИ и сокращать направление. 
		Можно ввести СЕВЕР, ЮГ, ВОСТОК, ЗАПАД, СЕВЕРОВОСТОК, ЮГОВОСТОК, СЕВЕРОЗАПАД,
		ЮГОЗАПАД, ВВЕРХ и ВНИЗ, или кратко С, Ю, В, З, СВ, ЮВ, СЗ, СВ, ВВ, ВН.^^";
	print "В некоторых локациях можно зайти ВНУТРЬ и выйти НАРУЖУ.^^";
];
[ OnObjects;
	print (ESB) "ОБЪЕКТЫ^";
	print "В течение игры вы встретите различные объекты, с которыми можно
		выполнять всевозможные действия. Предмет можно ВЗЯТЬ (ПОДНЯТЬ) и ПОЛОЖИТЬ
		(когда он вам надоел). ИНВЕНТАРЬ (или ИНВ) выведет список предметов,
		которые вы несёте с собой.^^";	
	print "С объектами можно выполнять ряд действий, и самые частые это — ОТКРЫТЬ,
		ЗАКРЫТЬ, НАДЕТЬ, СЪЕСТЬ, ЗАПЕРЕТЬ, ОТПЕРЕТЬ.^^";
	print "Иногда в игре может встретиться объект, название которого игра не распознаёт,
		хотя объект был указан в описании локации. Это значит, что этот объект является
		всего лишь декорацией, и с ним ничего не нужно делать.^^";
]; 
[ OnNPCs;
	print (ESB) "ПЕРСОНАЖИ^"; 
#ifdef NPC_MENU;
	MenuNPC();
	rtrue;
#endif;
#ifdef NPC_TALKTO;
	TalkToNPC();
	rtrue;
#endif;
#ifdef NPC_TOPIC;
	TopicMenuNPC();
	rtrue;
#endif; 
	AskTellNPC(); 
	rtrue;
];

[ AskTellNPC;
	print "Время от времени вы будете встречать людей и других существ. Вы не сможете объясняться
		с ними на разговорном русском. Вместо этого, для общения используется более ограниченная система.
		Четыре способа поговорить с персонажем:^^";
	print "Спросить его про объект.^";
	print (ESB) ">СПРОСИТЬ ПАВЛА О ЕГО БРАТЕ^";
	print (ESB) ">СПРОСИТЬ ЭЛЛИ ОБ УРАГАНЕ^^";
	print "Показать ему объект.^";
	print (ESB) ">ПОКАЗАТЬ ОРДЕР НАРКОБАРОНУ^";
	print (ESB) ">ПОКАЗАТЬ ВЕДРО ВОДЫ ЗЛОЙ ВЕДЬМЕ^^";
	print "Сказать ему про объект.^";
	print (ESB) ">СКАЗАТЬ МОРОЖЕНЩИКУ ПРО ЕГО ФУРГОН^";
	print (ESB) ">СКАЗАТЬ ДОРОТИ ПРО ЛЕТАЮЩИХ ОБЕЗЬЯН^^";
	print "Обратиться к ним.^";
	print (ESB) ">ФРЕДДИ, ПРИВЕТ^";
	print (ESB) ">МАЛЕНЬКИЙ МУК, ПОЛОЖИ ФРУКТ НА СТОЛ^";
	print "@<<ФРЕДДИ, ПРИВЕТ@>>, — это не обычная команда, и не все игры смогут понять её,
		но можете попробовать на всякий случай.^^";
];

[ MenuNPC;
	print "Время от времени вы будете встречать людей и других существ. Вы можете использовать
		команду >ГОВОРИТЬ С персонажем. В ответ игра предложит меню, с помощью которого станет
		возможно общение с персонажем на естественном языке.^^";
	print "Также может оказваться полезным продемонстрировать какие-либо объекты:^^"; 
	print (ESB) ">ПОКАЗАТЬ ОРДЕР НАРКОБАРОНУ^";
	print (ESB) ">ПОКАЗАТЬ ВЕДРО ВОДЫ ЗЛОЙ ВЕДЬМЕ^^";
	print "Или обратиться к ним.^";
	print (ESB) ">ФРЕДДИ, ПРИВЕТ^";
	print (ESB) ">МАЛЕНЬКИЙ МУК, ПОЛОЖИ ФРУКТ НА СТОЛ^";
	print "Но если вы ещё не совсем освоились, положитесь на меню.^";
];
[ TalkToNPC;
	print "Время от времени вы будете встречать людей и других существ. Вы не сможете объясняться
		с ними на разговорном русском. Вместо этого, можете использовать команду >ГОВОРИТЬ С
		персонажем, и игра решит, что должен сказать персонаж.^"; 
];

[ TopicMenuNPC;
	print "Время от времени вы будете встречать людей и других существ. Вы не сможете объясняться
		с ними на разговорном русском. Вместо этого, для общения используется более ограниченная система.
		Три способа поговорить с персонажем:^^";
	print "Поднять тему для обсуждения.^";
	print (ESB) ">СКАЗАТЬ БОБУ ПРО ФЛАГ^";
	print (ESB) ">СПРОСИТЬ БЕТТИ О ШОКОЛАДНОМ ПЕЧЕНЬЕ^^";
	print "Показать объект.^";
	print (ESB) ">ПОКАЗАТЬ ОРДЕР НАРКОБАРОНУ^";
	print (ESB) ">ПОКАЗАТЬ ВЕДРО ВОДЫ ЗЛОЙ ВЕДЬМЕ^^";
	print "Обратиться.^";
	print (ESB) ">ФРЕДДИ, ПРИВЕТ^";
	print (ESB) ">МАЛЕНЬКИЙ МУК, ПОЛОЖИ ФРУКТ НА СТОЛ^";
	print "Большинство персонажей не будет охотно исполнять ваши команды.^^";
];

[ MetaCommands;
	print (ESB) "МЕТАКОМАНДЫ^";
	print "Несколько простейших команд для управления самой игрой:^^";
	print (ESB) "СОХРАНИТЬ", " — Сохраняет текущее состояние игры.^";
	print (ESB) "ЗАГРУЗИТЬ", " — Возвращает игру к сохранённому состоянию.  (Вы можете сохранять столько состояний,
		сколько хотите.)^";
	print (ESB) "ПЕРЕЗАПУСК", " — Начинает игру сначала.^";
	print (ESB) "ОТМЕНА", " — Отменяет последнее действие и возвращает игру на один ход назад.^";
	print (ESB) "КОНЕЦ", " — Закрывает игру.^";
];


!---------------------------------------------------------------------------
! About the IF community online
!--------------------------------------------------------------------------- 

[ OnlineHelp;
	print (ESB) "ПОМОЩЬ В ИНТЕРНЕТЕ^^";
		print "Некоторые сетевые источники информации для новичков в ИЛ:^^";
		print "Инструкция для начинающих Фредерика Рамсберга (Frederik Ramsberg), www.octagate.com/Fredrik/IFGuide/^";
		print "Интерактивная литература — Начало, adamcadre.ac/content/if.txt^";
		print "Введение в интерактивную литературу, www.tads.org/if.htm^^";
		print "Для более подробной информации о ИЛ, связи с ИЛ-сообществом и поиска других игр,
			попробуйте зайти на:^^";
		print "Латунный фонарь, www.brasslantern.org^";
		print "Baf's Гид по интерактивной литературе Бэфа (Baf), www.wurb.com/if/index^^";
		print "Вы также можете найти специфическую информацию и подсказки по играм в новостной группе google:
			rec.games.int-fiction.^^";
		print "Если вы не знакомы с новостными группами, и у вас не настроена программа для чтения новостей,
			вы можете найти группу, зайдя на groups.google.com, и выбрав @<<rec@>>, затем @<<rec.games@>>,
			затем @<<rec.games.int-fiction@>>. Вы увидите длинный перечень тем, которые обсуждались ранее.
			Если вы никогда прежде не читали эту группу, прежде всего, найдите темы, содержащие аббревиатуру
			@<<FAQ@>>, и прочтите их. Так вы узнаете правила размещения постов, и прочие правила этикета,
			действующие в сообществе.^^";
];

[ MoreGames;
	print (ESB) "РУССКОЯЗЫЧНОЕ ИЛ-СООБЩЕСТВО^^";
	print "Дружелюбный Discord-сервер: https://discord.gg/X86kkzM^^";
	print "Главный форум, посвящённый интерактивной литературе, написанной для любых платформ: http://ifiction.ru/^^";
	print "Сайт, посвящённый русской адаптации платформы Inform (на которой написана эта игра), http://rinform.stormway.ru/^^";
	print "IRC-канал, на котором можно найти активных участников сообщества: #ifrus в сети irc.forestnet.org^";
];
